<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];

// Weekly hours last 8 weeks
$weeks = []; $week_data = [];
for ($i = 7; $i >= 0; $i--) {
    $start = date('Y-m-d', strtotime("-$i weeks monday"));
    $end   = date('Y-m-d', strtotime("-$i weeks sunday"));
    $r     = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COALESCE(SUM(hours),0) as h FROM study_sessions WHERE user_id=$uid AND session_date BETWEEN '$start' AND '$end'"));
    $weeks[]     = 'W' . date('W', strtotime($start));
    $week_data[] = round($r['h'], 1);
}

// Score trend (last 20 papers)
$score_res  = mysqli_query($conn, "SELECT done_date, subject, marks_obtained, total_marks FROM past_papers WHERE user_id=$uid ORDER BY done_date ASC, id ASC LIMIT 20");
$score_dates = []; $score_vals = [];
while ($r = mysqli_fetch_assoc($score_res)) {
    $score_dates[] = $r['subject'] . ' ' . $r['done_date'];
    $score_vals[]  = $r['total_marks'] > 0 ? round(($r['marks_obtained']/$r['total_marks'])*100,1) : 0;
}

// Day of week study pattern
$dow_data = [0,0,0,0,0,0,0];
$dow_res  = mysqli_query($conn, "SELECT DAYOFWEEK(session_date) as dow, SUM(hours) as h FROM study_sessions WHERE user_id=$uid GROUP BY dow");
while ($r = mysqli_fetch_assoc($dow_res)) $dow_data[$r['dow']-1] = round($r['h'],1);

// Subject heatmap data
$subject_months = [];
$sm_res = mysqli_query($conn, "SELECT subject, DATE_FORMAT(session_date,'%b %Y') as month, SUM(hours) as h FROM study_sessions WHERE user_id=$uid GROUP BY subject, month ORDER BY session_date DESC LIMIT 50");
while ($r = mysqli_fetch_assoc($sm_res)) {
    $subject_months[$r['subject']][$r['month']] = round($r['h'],1);
}

// Time of month study consistency
$daily_res = mysqli_query($conn, "SELECT session_date, SUM(hours) as h FROM study_sessions WHERE user_id=$uid AND session_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY) GROUP BY session_date");
$daily_map = [];
while ($r = mysqli_fetch_assoc($daily_res)) $daily_map[$r['session_date']] = $r['h'];

$streak     = getStreak($conn, $uid);
$longest    = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COALESCE(longest_streak,0) as l FROM streaks WHERE user_id=$uid"));
$longestStr = $longest ? $longest['l'] : 0;

$pageTitle = 'Analytics';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">📈</span> Analytics</h1>
        <p>Deep insights into your study patterns and performance trends.</p>
    </div>

    <div class="stats-grid" style="margin-bottom:1.5rem">
        <div class="stat-card purple"><div class="stat-icon">🔥</div><div class="stat-label">Current Streak</div><div class="stat-value" style="font-size:1.8rem"><?= $streak ?>d</div></div>
        <div class="stat-card green"><div class="stat-icon">⚡</div><div class="stat-label">Longest Streak</div><div class="stat-value" style="font-size:1.8rem"><?= $longestStr ?>d</div></div>
        <div class="stat-card blue"><div class="stat-icon">📊</div><div class="stat-label">Total Sessions</div>
            <?php $sc = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) as c FROM study_sessions WHERE user_id=$uid")); ?>
            <div class="stat-value" style="font-size:1.8rem"><?= $sc['c'] ?></div></div>
        <div class="stat-card orange"><div class="stat-icon">🎯</div><div class="stat-label">Avg Score</div><div class="stat-value" style="font-size:1.8rem"><?= getAvgScore($conn,$uid) ?>%</div></div>
    </div>

    <!-- Weekly hours + Score trend -->
    <div class="grid-2" style="margin-bottom:1.5rem">
        <div class="card">
            <div class="card-title">📅 Weekly Study Hours (Last 8 Weeks)</div>
            <canvas id="weeklyChart" height="220"></canvas>
        </div>
        <div class="card">
            <div class="card-title">📈 Past Paper Score Trend</div>
            <?php if (empty($score_vals)): ?>
                <div class="empty-state"><div class="empty-icon">📄</div><h3>No paper data</h3><p>Record past papers to see score trends.</p></div>
            <?php else: ?>
            <canvas id="scoreTrendChart" height="220"></canvas>
            <?php endif; ?>
        </div>
    </div>

    <!-- Day of week + 30-day calendar -->
    <div class="grid-2" style="margin-bottom:1.5rem">
        <div class="card">
            <div class="card-title">📆 Study by Day of Week</div>
            <canvas id="dowChart" height="220"></canvas>
        </div>
        <div class="card">
            <div class="card-title">🗓️ Last 30 Days Activity</div>
            <div style="display:grid;grid-template-columns:repeat(7,1fr);gap:4px;margin-top:0.5rem">
                <?php
                for ($i = 29; $i >= 0; $i--) {
                    $d = date('Y-m-d', strtotime("-$i days"));
                    $h = $daily_map[$d] ?? 0;
                    $opacity = $h > 0 ? min(1, 0.2 + ($h / 8)) : 0;
                    $color   = $h > 0 ? "rgba(108,63,197,$opacity)" : 'var(--bg-secondary)';
                    $title   = $d . ($h > 0 ? ": {$h}h" : ': no study');
                    echo "<div title='$title' style='height:28px;border-radius:4px;background:$color;border:1px solid var(--border);'></div>";
                }
                ?>
            </div>
            <div style="display:flex;gap:0.5rem;align-items:center;margin-top:0.75rem;font-size:0.75rem;color:var(--text-muted)">
                <span>Less</span>
                <?php for ($o = 0.2; $o <= 1; $o += 0.2): ?>
                <div style="width:16px;height:16px;border-radius:3px;background:rgba(108,63,197,<?= $o ?>)"></div>
                <?php endfor; ?>
                <span>More</span>
            </div>
        </div>
    </div>

    <!-- Subject performance heatmap -->
    <?php if (!empty($subject_months)): ?>
    <div class="card">
        <div class="card-title">🔥 Subject Study Heatmap</div>
        <div class="table-wrap">
            <table>
                <thead>
                    <tr><th>Subject</th>
                    <?php
                    $allMonths = [];
                    foreach ($subject_months as $sm) foreach (array_keys($sm) as $m) $allMonths[$m] = true;
                    $allMonths = array_keys($allMonths);
                    foreach ($allMonths as $m): ?><th><?= $m ?></th><?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($subject_months as $subj => $months): ?>
                <tr>
                    <td><span class="badge badge-purple"><?= htmlspecialchars($subj) ?></span></td>
                    <?php foreach ($allMonths as $m):
                        $h = $months[$m] ?? 0;
                        $bg = $h > 0 ? 'rgba(0,212,160,' . min(1, 0.1 + $h/20) . ')' : 'transparent';
                    ?>
                    <td style="background:<?= $bg ?>;color:<?= $h > 0 ? 'var(--green)' : 'var(--text-muted)' ?>;text-align:center;font-weight:<?= $h > 0 ? '600' : '400' ?>">
                        <?= $h > 0 ? $h . 'h' : '-' ?>
                    </td>
                    <?php endforeach; ?>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
new Chart(document.getElementById('weeklyChart'), {
    type: 'bar',
    data: {
        labels: <?= json_encode($weeks) ?>,
        datasets: [{
            label: 'Hours',
            data: <?= json_encode($week_data) ?>,
            backgroundColor: 'rgba(108,63,197,0.7)',
            borderColor: '#6c3fc5',
            borderWidth: 1,
            borderRadius: 6
        }]
    },
    options: { plugins:{legend:{display:false}}, scales:{y:{beginAtZero:true}} }
});

<?php if (!empty($score_vals)): ?>
new Chart(document.getElementById('scoreTrendChart'), {
    type: 'line',
    data: {
        labels: <?= json_encode(array_map(fn($l, $i) => '#'.($i+1), $score_dates, array_keys($score_dates))) ?>,
        datasets: [{
            label: 'Score %',
            data: <?= json_encode($score_vals) ?>,
            borderColor: '#00d4a0',
            backgroundColor: 'rgba(0,212,160,0.1)',
            borderWidth: 2.5,
            fill: true,
            tension: 0.4,
            pointBackgroundColor: '#00d4a0',
            pointRadius: 4
        }]
    },
    options: { plugins:{legend:{display:false}}, scales:{y:{beginAtZero:true,max:100}} }
});
<?php endif; ?>

new Chart(document.getElementById('dowChart'), {
    type: 'radar',
    data: {
        labels: ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],
        datasets: [{
            label: 'Hours',
            data: <?= json_encode($dow_data) ?>,
            borderColor: '#b44eff',
            backgroundColor: 'rgba(180,78,255,0.15)',
            borderWidth: 2,
            pointBackgroundColor: '#b44eff'
        }]
    },
    options: { plugins:{legend:{display:false}}, scales:{r:{beginAtZero:true, ticks:{color:'#5a5680'}, grid:{color:'#2a2a45'}, pointLabels:{color:'#a09cc0'}}} }
});
</script>

<?php include 'includes/footer.php'; ?>
