// StudyTrack LK - Main JS

// Auto-hide alerts
document.querySelectorAll('.alert').forEach(el => {
    setTimeout(() => { el.style.opacity = '0'; el.style.transition = '0.5s'; setTimeout(() => el.remove(), 500); }, 4000);
});

// Animate stat values
document.querySelectorAll('.stat-value[data-count]').forEach(el => {
    const target = parseFloat(el.dataset.count);
    const isDecimal = el.dataset.decimal;
    let current = 0;
    const step = target / 60;
    const timer = setInterval(() => {
        current += step;
        if (current >= target) { current = target; clearInterval(timer); }
        el.textContent = isDecimal ? current.toFixed(1) : Math.floor(current);
    }, 16);
});

// Progress bar animation
document.querySelectorAll('.progress-fill[data-width]').forEach(el => {
    const w = el.dataset.width;
    setTimeout(() => el.style.width = w + '%', 100);
});

// Confirm delete
document.querySelectorAll('[data-confirm]').forEach(el => {
    el.addEventListener('click', e => {
        if (!confirm(el.dataset.confirm || 'Are you sure?')) e.preventDefault();
    });
});

// Form validation highlight
document.querySelectorAll('form').forEach(form => {
    form.addEventListener('submit', () => {
        form.querySelectorAll('[required]').forEach(input => {
            if (!input.value.trim()) {
                input.style.borderColor = 'var(--danger)';
            } else {
                input.style.borderColor = '';
            }
        });
    });
});

// Chart default config
if (typeof Chart !== 'undefined') {
    Chart.defaults.color          = '#a09cc0';
    Chart.defaults.borderColor    = '#2a2a45';
    Chart.defaults.font.family    = 'Inter';
    Chart.defaults.plugins.legend.labels.padding = 16;
    Chart.defaults.plugins.legend.labels.usePointStyle = true;
}
