-- =============================================
-- StudyTrack LK - Full Database Setup
-- Run this in phpMyAdmin > SQL tab
-- =============================================

CREATE DATABASE IF NOT EXISTS studytrack_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE studytrack_db;

-- Users
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    stream ENUM('Maths','Bio','Arts','Commerce','Tech') NOT NULL,
    target_zscore DECIMAL(5,4) DEFAULT 0,
    exam_year YEAR,
    profile_pic VARCHAR(255) DEFAULT NULL,
    is_admin TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Study Sessions
CREATE TABLE IF NOT EXISTS study_sessions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    subject VARCHAR(100) NOT NULL,
    hours DECIMAL(4,2) NOT NULL,
    notes TEXT,
    session_date DATE NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Past Papers
CREATE TABLE IF NOT EXISTS past_papers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    subject VARCHAR(100) NOT NULL,
    year YEAR NOT NULL,
    paper_type ENUM('MCQ','Structured','Essay') NOT NULL,
    marks_obtained INT NOT NULL,
    total_marks INT NOT NULL,
    done_date DATE NOT NULL,
    notes TEXT,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Goals
CREATE TABLE IF NOT EXISTS goals (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    subject VARCHAR(100) NOT NULL,
    target_grade ENUM('A','B','C','S','F') NOT NULL,
    current_grade ENUM('A','B','C','S','F') DEFAULT 'F',
    notes TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Reminders / Notifications
CREATE TABLE IF NOT EXISTS reminders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    title VARCHAR(200) NOT NULL,
    description TEXT,
    remind_date DATETIME NOT NULL,
    is_done TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Badges / Achievements
CREATE TABLE IF NOT EXISTS badges (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    badge_name VARCHAR(100) NOT NULL,
    badge_icon VARCHAR(10) DEFAULT '🏅',
    earned_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Study Streaks
CREATE TABLE IF NOT EXISTS streaks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL UNIQUE,
    current_streak INT DEFAULT 0,
    longest_streak INT DEFAULT 0,
    last_study_date DATE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- University Z-Score Cutoffs
CREATE TABLE IF NOT EXISTS university_cutoffs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    university VARCHAR(200) NOT NULL,
    faculty VARCHAR(200) NOT NULL,
    stream ENUM('Maths','Bio','Arts','Commerce','Tech') NOT NULL,
    year YEAR NOT NULL,
    min_zscore DECIMAL(5,4) NOT NULL
);

-- Insert sample university data
INSERT INTO university_cutoffs (university, faculty, stream, year, min_zscore) VALUES
('University of Colombo', 'Faculty of Medicine', 'Bio', 2023, 1.9876),
('University of Peradeniya', 'Faculty of Engineering', 'Maths', 2023, 1.8543),
('University of Moratuwa', 'Faculty of IT', 'Maths', 2023, 1.7234),
('University of Colombo', 'Faculty of Science', 'Bio', 2023, 1.6543),
('University of Kelaniya', 'Faculty of Commerce', 'Commerce', 2023, 1.4321),
('University of Sri Jayewardenepura', 'Faculty of Management', 'Commerce', 2023, 1.3876),
('University of Ruhuna', 'Faculty of Engineering', 'Maths', 2023, 1.6234),
('Eastern University', 'Faculty of Agriculture', 'Bio', 2023, 1.2543);

-- Admin user (password: admin123)
INSERT INTO users (name, email, password, stream, is_admin) VALUES
('Admin', 'admin@studytrack.lk', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Maths', 1);
