<?php
function requireLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: " . (defined("BASE_PATH") ? BASE_PATH : "") . "/login.php");
        exit();
    }
}

function requireAdmin() {
    requireLogin();
    if (!isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
        header("Location: " . (defined("BASE_PATH") ? BASE_PATH : "") . "/dashboard.php");
        exit();
    }
}

function sanitize($conn, $val) {
    return mysqli_real_escape_string($conn, htmlspecialchars(trim($val)));
}

function getUser($conn, $id) {
    $id = (int)$id;
    $r  = mysqli_query($conn, "SELECT * FROM users WHERE id=$id");
    return mysqli_fetch_assoc($r);
}

function getWeekHours($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COALESCE(SUM(hours),0) as total FROM study_sessions
         WHERE user_id=$uid AND session_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)"));
    return round($r['total'], 1);
}

function getTotalHours($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COALESCE(SUM(hours),0) as total FROM study_sessions WHERE user_id=$uid"));
    return round($r['total'], 1);
}

function getPapersCount($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COUNT(*) as total FROM past_papers WHERE user_id=$uid"));
    return $r['total'];
}

function getStreak($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT * FROM streaks WHERE user_id=$uid"));
    return $r ? $r['current_streak'] : 0;
}

function updateStreak($conn, $uid) {
    $uid   = (int)$uid;
    $today = date('Y-m-d');
    $r     = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM streaks WHERE user_id=$uid"));
    if (!$r) {
        mysqli_query($conn, "INSERT INTO streaks (user_id, current_streak, longest_streak, last_study_date)
                             VALUES ($uid, 1, 1, '$today')");
    } else {
        $last    = $r['last_study_date'];
        $current = $r['current_streak'];
        $longest = $r['longest_streak'];
        $yesterday = date('Y-m-d', strtotime('-1 day'));
        if ($last == $today) return;
        if ($last == $yesterday) {
            $current++;
            $longest = max($longest, $current);
        } else {
            $current = 1;
        }
        mysqli_query($conn, "UPDATE streaks SET current_streak=$current, longest_streak=$longest,
                             last_study_date='$today' WHERE user_id=$uid");
    }
}

function checkAndAwardBadges($conn, $uid) {
    $uid        = (int)$uid;
    $totalHours = getTotalHours($conn, $uid);
    $papers     = getPapersCount($conn, $uid);
    $streak     = getStreak($conn, $uid);

    $possible = [
        ['name' => 'First Step',      'icon' => '🌱', 'condition' => $totalHours >= 1],
        ['name' => '10 Hours Club',   'icon' => '⏰', 'condition' => $totalHours >= 10],
        ['name' => '50 Hours Hero',   'icon' => '🔥', 'condition' => $totalHours >= 50],
        ['name' => '100 Hours Legend','icon' => '💯', 'condition' => $totalHours >= 100],
        ['name' => 'Paper Crusher',   'icon' => '📝', 'condition' => $papers >= 5],
        ['name' => 'Exam Master',     'icon' => '🏆', 'condition' => $papers >= 20],
        ['name' => '7-Day Streak',    'icon' => '🔗', 'condition' => $streak >= 7],
        ['name' => '30-Day Streak',   'icon' => '⚡', 'condition' => $streak >= 30],
    ];

    foreach ($possible as $b) {
        if ($b['condition']) {
            $name = sanitize($conn, $b['name']);
            $icon = $b['icon'];
            $exists = mysqli_fetch_assoc(mysqli_query($conn,
                "SELECT id FROM badges WHERE user_id=$uid AND badge_name='$name'"));
            if (!$exists) {
                mysqli_query($conn, "INSERT INTO badges (user_id, badge_name, badge_icon)
                                     VALUES ($uid, '$name', '$icon')");
            }
        }
    }
}

function getAvgScore($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COALESCE(AVG((marks_obtained/total_marks)*100),0) as avg FROM past_papers WHERE user_id=$uid"));
    return round($r['avg'], 1);
}

function getSubjectHours($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_query($conn,
        "SELECT subject, SUM(hours) as total FROM study_sessions WHERE user_id=$uid GROUP BY subject ORDER BY total DESC");
    $data = [];
    while ($row = mysqli_fetch_assoc($r)) $data[] = $row;
    return $data;
}

function getRecentSessions($conn, $uid, $limit = 5) {
    $uid = (int)$uid;
    $r   = mysqli_query($conn,
        "SELECT * FROM study_sessions WHERE user_id=$uid ORDER BY session_date DESC, id DESC LIMIT $limit");
    $data = [];
    while ($row = mysqli_fetch_assoc($r)) $data[] = $row;
    return $data;
}

function getPapersBySubject($conn, $uid) {
    $uid = (int)$uid;
    $r   = mysqli_query($conn,
        "SELECT subject, COUNT(*) as cnt, AVG((marks_obtained/total_marks)*100) as avg_score
         FROM past_papers WHERE user_id=$uid GROUP BY subject");
    $data = [];
    while ($row = mysqli_fetch_assoc($r)) $data[] = $row;
    return $data;
}

function gradeFromPercent($pct) {
    if ($pct >= 75) return 'A';
    if ($pct >= 65) return 'B';
    if ($pct >= 50) return 'C';
    if ($pct >= 35) return 'S';
    return 'F';
}

function gradeColor($grade) {
    return match($grade) {
        'A' => '#10b981', 'B' => '#6366f1',
        'C' => '#f59e0b', 'S' => '#f97316', default => '#f87171'
    };
}
?>
