<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'StudyTrack LK' ?> | StudyTrack LK</title>
    <link rel="stylesheet" href="<?= BASE_PATH ?>/assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>📚</text></svg>">
</head>
<body>

<?php $b = BASE_PATH; ?>
<nav class="navbar">
    <div class="nav-brand">
        <span class="nav-logo">📚</span>
        <span class="nav-title">StudyTrack <span class="accent">LK</span></span>
    </div>
    <ul class="nav-links" id="navLinks">
        <li><a href="<?=$b?>/dashboard.php"   <?= (basename($_SERVER['PHP_SELF'])=='dashboard.php')  ?'class="active"':'' ?>><span>🏠</span> Dashboard</a></li>
        <li><a href="<?=$b?>/study-log.php"   <?= (basename($_SERVER['PHP_SELF'])=='study-log.php')  ?'class="active"':'' ?>><span>⏱️</span> Study Log</a></li>
        <li><a href="<?=$b?>/past-papers.php" <?= (basename($_SERVER['PHP_SELF'])=='past-papers.php')?'class="active"':'' ?>><span>📝</span> Past Papers</a></li>
        <li><a href="<?=$b?>/goals.php"       <?= (basename($_SERVER['PHP_SELF'])=='goals.php')      ?'class="active"':'' ?>><span>🎯</span> Goals</a></li>
        <li><a href="<?=$b?>/analytics.php"   <?= (basename($_SERVER['PHP_SELF'])=='analytics.php')  ?'class="active"':'' ?>><span>📊</span> Analytics</a></li>
        <li><a href="<?=$b?>/reminders.php"   <?= (basename($_SERVER['PHP_SELF'])=='reminders.php')  ?'class="active"':'' ?>><span>🔔</span> Reminders</a></li>
        <li><a href="<?=$b?>/university.php"  <?= (basename($_SERVER['PHP_SELF'])=='university.php') ?'class="active"':'' ?>><span>🏛️</span> Universities</a></li>
        <li><a href="<?=$b?>/ai-feedback.php" <?= (basename($_SERVER['PHP_SELF'])=='ai-feedback.php')?'class="active"':'' ?>
            style="background:linear-gradient(135deg,rgba(108,63,197,0.15),rgba(180,78,255,0.1));border:1px solid rgba(108,63,197,0.25)">
            <span>🤖</span> AI Feedback</a></li>
        <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']): ?>
        <li><a href="<?=$b?>/admin/dashboard.php"><span>⚙️</span> Admin</a></li>
        <?php endif; ?>
    </ul>
    <div class="nav-user">
        <span class="user-avatar"><?= strtoupper(substr($_SESSION['user_name'] ?? 'U', 0, 1)) ?></span>
        <span class="user-name"><?= htmlspecialchars($_SESSION['user_name'] ?? '') ?></span>
        <a href="<?=$b?>/logout.php" class="btn-logout">Logout</a>
    </div>
    <button class="hamburger" onclick="document.getElementById('navLinks').classList.toggle('open')">☰</button>
</nav>
