<?php
session_start();
include 'includes/db.php'; // BASE_PATH defined here first

if (isset($_SESSION['user_id'])) {
    header("Location: " . BASE_PATH . "/dashboard.php");
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email     = trim($_POST['email']    ?? '');
    $pass      = $_POST['password']      ?? '';
    $emailSafe = mysqli_real_escape_string($conn, $email);
    $result    = mysqli_query($conn, "SELECT * FROM users WHERE email='$emailSafe'");
    $user      = mysqli_fetch_assoc($result);

    if ($user && password_verify($pass, $user['password'])) {
        $_SESSION['user_id']   = $user['id'];
        $_SESSION['user_name'] = $user['name'];
        $_SESSION['stream']    = $user['stream'];
        $_SESSION['is_admin']  = $user['is_admin'];
        header("Location: " . BASE_PATH . "/dashboard.php");
        exit();
    } else {
        $error = 'Invalid email or password.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | StudyTrack LK</title>
    <link rel="stylesheet" href="<?= BASE_PATH ?>/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
<div class="auth-page">
    <div class="auth-card">
        <div class="auth-logo">
            <span class="logo-icon">📚</span>
            <h1>StudyTrack <span class="accent">LK</span></h1>
            <p>Welcome back! Sign in to continue.</p>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error">⚠️ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <?php if (isset($_GET['registered'])): ?>
            <div class="alert alert-success">✅ Account created! Please sign in.</div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label class="form-label">Email Address</label>
                <input type="email" name="email" class="form-control"
                    placeholder="your@email.com" required autofocus>
            </div>
            <div class="form-group">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control"
                    placeholder="Your password" required>
            </div>
            <button type="submit" class="btn btn-primary btn-block">🔐 Sign In</button>
        </form>

        <p class="auth-footer" style="margin-top:1.5rem">
            Don't have an account? <a href="<?= BASE_PATH ?>/register.php">Create one free</a>
        </p>
        <p class="auth-footer" style="margin-top:0.5rem">
            <a href="<?= BASE_PATH ?>/">← Back to Home</a>
        </p>
    </div>
</div>
<script src="<?= BASE_PATH ?>/assets/js/main.js"></script>
</body>
</html>
