<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];
$msg = ''; $err = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add') {
    $subject  = sanitize($conn, $_POST['subject'] ?? '');
    $year     = (int)($_POST['paper_year'] ?? 0);
    $type     = sanitize($conn, $_POST['paper_type'] ?? '');
    $obtained = (int)($_POST['marks_obtained'] ?? 0);
    $total    = (int)($_POST['total_marks'] ?? 100);
    $date     = sanitize($conn, $_POST['done_date'] ?? date('Y-m-d'));
    $notes    = sanitize($conn, $_POST['notes'] ?? '');

    if (!$subject || !$year || !$type || $total <= 0) {
        $err = 'Please fill all required fields.';
    } elseif ($obtained > $total) {
        $err = 'Marks obtained cannot exceed total marks.';
    } else {
        mysqli_query($conn, "INSERT INTO past_papers (user_id, subject, year, paper_type, marks_obtained, total_marks, done_date, notes)
                             VALUES ($uid, '$subject', $year, '$type', $obtained, $total, '$date', '$notes')");
        checkAndAwardBadges($conn, $uid);
        $msg = 'Past paper recorded! ✅';
    }
}

if (isset($_GET['delete'])) {
    $did = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM past_papers WHERE id=$did AND user_id=$uid");
    header("Location: " . BASE_PATH . "/past-papers.php?deleted=1");
    exit();
}
if (isset($_GET['deleted'])) $msg = 'Record deleted.';

// Get papers
$papers = mysqli_query($conn, "SELECT * FROM past_papers WHERE user_id=$uid ORDER BY done_date DESC, id DESC");
$bySubject = getPapersBySubject($conn, $uid);

$pageTitle = 'Past Papers';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">📝</span> Past Papers</h1>
        <p>Track your performance on past papers and identify areas to improve.</p>
    </div>

    <?php if ($msg): ?><div class="alert alert-success">✅ <?= htmlspecialchars($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error">⚠️ <?= htmlspecialchars($err) ?></div><?php endif; ?>

    <div class="grid-main-side">
        <div>
            <!-- ADD FORM -->
            <div class="card" style="margin-bottom:1.5rem">
                <div class="card-title">➕ Record Past Paper</div>
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="form-grid">
                        <div class="form-group">
                            <label class="form-label">Subject *</label>
                            <select name="subject" class="form-control" required>
                                <option value="">Select Subject</option>
                                <?php foreach(['Combined Maths','Physics','Chemistry','Biology','ICT','Economics','Accounting','Business Studies','History','Geography','Art','Sinhala','Tamil','English','Other'] as $s): ?>
                                <option value="<?= $s ?>"><?= $s ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Paper Year *</label>
                            <select name="paper_year" class="form-control" required>
                                <option value="">Select Year</option>
                                <?php for ($y = 2024; $y >= 2005; $y--): ?>
                                <option value="<?= $y ?>"><?= $y ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-grid">
                        <div class="form-group">
                            <label class="form-label">Paper Type *</label>
                            <select name="paper_type" class="form-control" required>
                                <option value="">Select Type</option>
                                <option value="MCQ">MCQ</option>
                                <option value="Structured">Structured</option>
                                <option value="Essay">Essay</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Date Done</label>
                            <input type="date" name="done_date" class="form-control" value="<?= date('Y-m-d') ?>">
                        </div>
                    </div>
                    <div class="form-grid">
                        <div class="form-group">
                            <label class="form-label">Marks Obtained *</label>
                            <input type="number" name="marks_obtained" class="form-control" placeholder="e.g. 72" min="0" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Total Marks *</label>
                            <input type="number" name="total_marks" class="form-control" placeholder="e.g. 100" min="1" value="100" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Notes (optional)</label>
                        <textarea name="notes" class="form-control" placeholder="Topics you struggled with, comments..."></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block">📝 Save Record</button>
                </form>
            </div>

            <!-- PAPERS TABLE -->
            <div class="card">
                <div class="card-title">📋 All Past Papers</div>
                <?php
                $rows = mysqli_num_rows($papers);
                if ($rows == 0): ?>
                    <div class="empty-state"><div class="empty-icon">📄</div><h3>No papers recorded</h3><p>Record your first past paper above.</p></div>
                <?php else:
                    mysqli_data_seek($papers, 0); ?>
                <div class="table-wrap">
                    <table>
                        <thead><tr><th>Date</th><th>Subject</th><th>Year</th><th>Type</th><th>Score</th><th>%</th><th>Grade</th><th></th></tr></thead>
                        <tbody>
                        <?php while ($p = mysqli_fetch_assoc($papers)):
                            $pct   = $p['total_marks'] > 0 ? round(($p['marks_obtained']/$p['total_marks'])*100, 1) : 0;
                            $grade = gradeFromPercent($pct);
                        ?>
                            <tr>
                                <td><?= date('M d', strtotime($p['done_date'])) ?></td>
                                <td><span class="badge badge-purple"><?= htmlspecialchars($p['subject']) ?></span></td>
                                <td><?= $p['year'] ?></td>
                                <td><?= $p['paper_type'] ?></td>
                                <td><?= $p['marks_obtained'] ?>/<?= $p['total_marks'] ?></td>
                                <td style="font-weight:600;color:<?= $pct >= 65 ? 'var(--green)' : ($pct >= 50 ? 'var(--warning)' : 'var(--danger)') ?>"><?= $pct ?>%</td>
                                <td><span class="badge badge-<?= $grade ?>"><?= $grade ?></span></td>
                                <td><a href="?delete=<?= $p['id'] ?>" class="btn btn-danger btn-sm" data-confirm="Delete this record?">🗑️</a></td>
                            </tr>
                        <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- SIDEBAR -->
        <div style="display:flex;flex-direction:column;gap:1.5rem">
            <div class="stat-card green">
                <div class="stat-icon">📝</div>
                <div class="stat-label">Papers Done</div>
                <div class="stat-value" style="font-size:1.8rem"><?= getPapersCount($conn,$uid) ?></div>
            </div>
            <div class="stat-card purple">
                <div class="stat-icon">🎯</div>
                <div class="stat-label">Avg Score</div>
                <div class="stat-value" style="font-size:1.8rem"><?= getAvgScore($conn,$uid) ?>%</div>
            </div>

            <!-- By Subject -->
            <div class="card">
                <div class="card-title">📊 Performance by Subject</div>
                <?php if (empty($bySubject)): ?>
                    <p style="color:var(--text-muted);font-size:0.83rem;text-align:center">No data yet</p>
                <?php else: ?>
                <canvas id="subjectPerfChart" height="250"></canvas>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if (!empty($bySubject)):
    $perfLabels = array_column($bySubject, 'subject');
    $perfData   = array_map(fn($r) => round($r['avg_score'],1), $bySubject);
?>
<script>
new Chart(document.getElementById('subjectPerfChart'), {
    type: 'bar',
    data: {
        labels: <?= json_encode($perfLabels) ?>,
        datasets: [{
            label: 'Avg Score %',
            data: <?= json_encode($perfData) ?>,
            backgroundColor: <?= json_encode(array_map(fn($s) => $s >= 65 ? 'rgba(0,212,160,0.7)' : ($s >= 50 ? 'rgba(245,158,11,0.7)' : 'rgba(255,77,109,0.7)'), $perfData)) ?>,
            borderRadius: 6
        }]
    },
    options: { plugins: { legend: { display:false } }, scales: { y: { beginAtZero:true, max:100 } }, indexAxis: 'y' }
});
</script>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>
