<?php
session_start();
include 'includes/db.php'; // BASE_PATH defined here first

if (isset($_SESSION['user_id'])) {
    header("Location: " . BASE_PATH . "/dashboard.php");
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name   = trim($_POST['name']    ?? '');
    $email  = trim($_POST['email']   ?? '');
    $pass   = $_POST['password']     ?? '';
    $pass2  = $_POST['password2']    ?? '';
    $stream = $_POST['stream']       ?? '';
    $year   = (int)($_POST['exam_year']     ?? date('Y'));
    $zscore = (float)($_POST['target_zscore'] ?? 0);

    if (!$name || !$email || !$pass || !$stream) {
        $error = 'Please fill all required fields.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } elseif (strlen($pass) < 6) {
        $error = 'Password must be at least 6 characters.';
    } elseif ($pass !== $pass2) {
        $error = 'Passwords do not match.';
    } else {
        $emailSafe  = mysqli_real_escape_string($conn, $email);
        $nameSafe   = mysqli_real_escape_string($conn, $name);
        $streamSafe = mysqli_real_escape_string($conn, $stream);

        $check = mysqli_query($conn, "SELECT id FROM users WHERE email='$emailSafe'");
        if (mysqli_num_rows($check) > 0) {
            $error = 'This email is already registered.';
        } else {
            $hashPass = password_hash($pass, PASSWORD_BCRYPT);
            $sql = "INSERT INTO users (name, email, password, stream, exam_year, target_zscore)
                    VALUES ('$nameSafe', '$emailSafe', '$hashPass', '$streamSafe', $year, $zscore)";
            if (mysqli_query($conn, $sql)) {
                $uid = mysqli_insert_id($conn);
                mysqli_query($conn, "INSERT INTO streaks (user_id, current_streak, longest_streak) VALUES ($uid, 0, 0)");
                header("Location: " . BASE_PATH . "/login.php?registered=1");
                exit();
            } else {
                $error = 'Registration failed: ' . mysqli_error($conn);
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register | StudyTrack LK</title>
    <link rel="stylesheet" href="<?= BASE_PATH ?>/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
<div class="auth-page">
    <div class="auth-card">
        <div class="auth-logo">
            <span class="logo-icon">📚</span>
            <h1>StudyTrack <span class="accent">LK</span></h1>
            <p>Create your free account</p>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error">⚠️ <?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label class="form-label">Full Name *</label>
                <input type="text" name="name" class="form-control"
                    placeholder="Your full name"
                    value="<?= htmlspecialchars($_POST['name'] ?? '') ?>" required>
            </div>
            <div class="form-group">
                <label class="form-label">Email Address *</label>
                <input type="email" name="email" class="form-control"
                    placeholder="your@email.com"
                    value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
            </div>
            <div class="form-grid">
                <div class="form-group">
                    <label class="form-label">Password *</label>
                    <input type="password" name="password" class="form-control"
                        placeholder="Min. 6 characters" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Confirm Password *</label>
                    <input type="password" name="password2" class="form-control"
                        placeholder="Repeat password" required>
                </div>
            </div>
            <div class="form-grid">
                <div class="form-group">
                    <label class="form-label">A/L Stream *</label>
                    <select name="stream" class="form-control" required>
                        <option value="">Select Stream</option>
                        <option value="Maths"    <?= (($_POST['stream']??'')=='Maths')   ?'selected':''?>>Combined Maths</option>
                        <option value="Bio"      <?= (($_POST['stream']??'')=='Bio')     ?'selected':''?>>Biology</option>
                        <option value="Arts"     <?= (($_POST['stream']??'')=='Arts')    ?'selected':''?>>Arts</option>
                        <option value="Commerce" <?= (($_POST['stream']??'')=='Commerce')?'selected':''?>>Commerce</option>
                        <option value="Tech"     <?= (($_POST['stream']??'')=='Tech')    ?'selected':''?>>Technology</option>
                    </select>
                </div>
                <div class="form-group">
                    <label class="form-label">Exam Year *</label>
                    <input type="number" name="exam_year" class="form-control"
                        placeholder="e.g. 2025" min="2024" max="2030"
                        value="<?= htmlspecialchars($_POST['exam_year'] ?? date('Y')) ?>" required>
                </div>
            </div>
            <div class="form-group">
                <label class="form-label">Target Z-Score <span style="color:var(--text-muted)">(optional)</span></label>
                <input type="number" name="target_zscore" class="form-control"
                    placeholder="e.g. 1.9500" step="0.0001" min="0" max="3"
                    value="<?= htmlspecialchars($_POST['target_zscore'] ?? '') ?>">
            </div>
            <button type="submit" class="btn btn-primary btn-block">🚀 Create Account</button>
        </form>

        <p class="auth-footer" style="margin-top:1.5rem">
            Already have an account? <a href="<?= BASE_PATH ?>/login.php">Sign In</a>
        </p>
        <p class="auth-footer" style="margin-top:0.5rem">
            <a href="<?= BASE_PATH ?>/">← Back to Home</a>
        </p>
    </div>
</div>
<script src="<?= BASE_PATH ?>/assets/js/main.js"></script>
</body>
</html>
