<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];
$msg = ''; $err = '';

// Add session
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add') {
    $subject = sanitize($conn, $_POST['subject'] ?? '');
    $hours   = (float)($_POST['hours'] ?? 0);
    $date    = sanitize($conn, $_POST['session_date'] ?? '');
    $notes   = sanitize($conn, $_POST['notes'] ?? '');
    if (!$subject || $hours <= 0 || !$date) {
        $err = 'Please fill all required fields.';
    } else {
        mysqli_query($conn, "INSERT INTO study_sessions (user_id, subject, hours, notes, session_date)
                             VALUES ($uid, '$subject', $hours, '$notes', '$date')");
        updateStreak($conn, $uid);
        checkAndAwardBadges($conn, $uid);
        $msg = 'Study session logged successfully! ✅';
    }
}

// Delete
if (isset($_GET['delete'])) {
    $did = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM study_sessions WHERE id=$did AND user_id=$uid");
    header("Location: " . BASE_PATH . "/study-log.php?deleted=1");
    exit();
}
if (isset($_GET['deleted'])) $msg = 'Session deleted.';

// Get all sessions
$page  = max(1, (int)($_GET['page'] ?? 1));
$limit = 15;
$offset = ($page - 1) * $limit;
$total_res = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM study_sessions WHERE user_id=$uid"));
$total_pages = ceil($total_res['c'] / $limit);
$sessions = mysqli_query($conn, "SELECT * FROM study_sessions WHERE user_id=$uid ORDER BY session_date DESC, id DESC LIMIT $limit OFFSET $offset");

$pageTitle = 'Study Log';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">⏱️</span> Study Log</h1>
        <p>Track every study session to build consistency and monitor progress.</p>
    </div>

    <?php if ($msg): ?><div class="alert alert-success">✅ <?= htmlspecialchars($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error">⚠️ <?= htmlspecialchars($err) ?></div><?php endif; ?>

    <div class="grid-main-side">
        <!-- ADD FORM -->
        <div>
            <div class="card" style="margin-bottom:1.5rem">
                <div class="card-title">➕ Log New Study Session</div>
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="form-grid">
                        <div class="form-group">
                            <label class="form-label">Subject *</label>
                            <select name="subject" class="form-control" required>
                                <option value="">Select Subject</option>
                                <?php
                                $subjects = ['Combined Maths','Physics','Chemistry','Biology','ICT','Economics','Accounting','Business Studies','History','Geography','Art','Sinhala','Tamil','English','Other'];
                                foreach ($subjects as $s): ?>
                                <option value="<?= $s ?>"><?= $s ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Hours Studied *</label>
                            <input type="number" name="hours" class="form-control" placeholder="e.g. 2.5" step="0.25" min="0.25" max="16" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Date *</label>
                        <input type="date" name="session_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Notes (optional)</label>
                        <textarea name="notes" class="form-control" placeholder="What did you study? Any weak areas?"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block">📝 Log Session</button>
                </form>
            </div>

            <!-- SESSIONS TABLE -->
            <div class="card">
                <div class="card-title">📋 All Sessions (<?= $total_res['c'] ?>)</div>
                <?php if (mysqli_num_rows($sessions) == 0): ?>
                    <div class="empty-state"><div class="empty-icon">⏰</div><h3>No sessions yet</h3><p>Start logging your study sessions above.</p></div>
                <?php else: ?>
                <div class="table-wrap">
                    <table>
                        <thead><tr><th>Date</th><th>Subject</th><th>Hours</th><th>Notes</th><th>Action</th></tr></thead>
                        <tbody>
                        <?php while ($s = mysqli_fetch_assoc($sessions)): ?>
                            <tr>
                                <td><?= date('M d, Y', strtotime($s['session_date'])) ?></td>
                                <td><span class="badge badge-purple"><?= htmlspecialchars($s['subject']) ?></span></td>
                                <td style="color:var(--green);font-weight:700"><?= $s['hours'] ?>h</td>
                                <td style="color:var(--text-muted);font-size:0.82rem"><?= htmlspecialchars(substr($s['notes'] ?? '-', 0, 50)) ?></td>
                                <td>
                                    <a href="?delete=<?= $s['id'] ?>" class="btn btn-danger btn-sm" data-confirm="Delete this session?">🗑️</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                <!-- Pagination -->
                <?php if ($total_pages > 1): ?>
                <div style="display:flex;gap:0.5rem;margin-top:1rem;justify-content:center">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <a href="?page=<?= $i ?>" class="btn btn-sm <?= $i == $page ? 'btn-primary' : 'btn-outline' ?>"><?= $i ?></a>
                    <?php endfor; ?>
                </div>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

        <!-- SIDEBAR STATS -->
        <div style="display:flex;flex-direction:column;gap:1.5rem">
            <div class="stat-card purple">
                <div class="stat-icon">📅</div>
                <div class="stat-label">This Week</div>
                <div class="stat-value" style="font-size:1.8rem"><?= getWeekHours($conn,$uid) ?>h</div>
            </div>
            <div class="stat-card green">
                <div class="stat-icon">📚</div>
                <div class="stat-label">Total Hours</div>
                <div class="stat-value" style="font-size:1.8rem"><?= getTotalHours($conn,$uid) ?>h</div>
            </div>
            <div class="card">
                <div class="card-title">📊 Hours by Subject</div>
                <?php
                $shours = getSubjectHours($conn, $uid);
                $maxH   = max(array_column($shours, 'total') ?: [0]);
                foreach ($shours as $sh): ?>
                <div style="margin-bottom:0.75rem">
                    <div style="display:flex;justify-content:space-between;font-size:0.83rem;margin-bottom:0.25rem">
                        <span><?= htmlspecialchars($sh['subject']) ?></span>
                        <span style="color:var(--green)"><?= round($sh['total'],1) ?>h</span>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill green" data-width="<?= $maxH > 0 ? round(($sh['total']/$maxH)*100) : 0 ?>" style="width:0"></div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
