<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];
$user = getUser($conn, $uid);

$stream_filter = sanitize($conn, $_GET['stream'] ?? $user['stream']);
$cutoffs = mysqli_query($conn, "SELECT * FROM university_cutoffs WHERE stream='$stream_filter' ORDER BY min_zscore DESC");

$pageTitle = 'University Cutoffs';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">🏛️</span> University Z-Score Cutoffs</h1>
        <p>Check minimum Z-scores required for Sri Lankan universities.</p>
    </div>

    <!-- Filter -->
    <div class="card" style="margin-bottom:1.5rem;padding:1rem 1.5rem">
        <form method="GET" style="display:flex;gap:1rem;align-items:center;flex-wrap:wrap">
            <label class="form-label" style="margin:0;white-space:nowrap">Filter by Stream:</label>
            <select name="stream" class="form-control" style="width:auto" onchange="this.form.submit()">
                <?php foreach(['Maths','Bio','Arts','Commerce','Tech'] as $s): ?>
                <option value="<?= $s ?>" <?= $s == $stream_filter ? 'selected':'' ?>><?= $s ?></option>
                <?php endforeach; ?>
            </select>
            <?php if ($user['target_zscore'] > 0): ?>
            <div style="margin-left:auto;background:rgba(0,212,160,0.1);border:1px solid rgba(0,212,160,0.2);border-radius:8px;padding:0.5rem 1rem;font-size:0.85rem">
                🎯 Your Target: <strong style="color:var(--green)"><?= number_format($user['target_zscore'],4) ?></strong>
            </div>
            <?php endif; ?>
        </form>
    </div>

    <div class="card">
        <div class="card-title">📋 Cutoff Z-Scores — <?= $stream_filter ?> Stream</div>
        <?php if (mysqli_num_rows($cutoffs) == 0): ?>
            <div class="empty-state"><div class="empty-icon">🏫</div><h3>No data for this stream</h3></div>
        <?php else: ?>
        <div class="table-wrap">
            <table>
                <thead><tr><th>University</th><th>Faculty</th><th>Min Z-Score</th><th>Status</th></tr></thead>
                <tbody>
                <?php while ($c = mysqli_fetch_assoc($cutoffs)):
                    $myZ     = (float)$user['target_zscore'];
                    $minZ    = (float)$c['min_zscore'];
                    $canGet  = $myZ > 0 && $myZ >= $minZ;
                    $close   = $myZ > 0 && !$canGet && ($minZ - $myZ) < 0.2;
                ?>
                <tr>
                    <td style="font-weight:600"><?= htmlspecialchars($c['university']) ?></td>
                    <td style="color:var(--text-secondary)"><?= htmlspecialchars($c['faculty']) ?></td>
                    <td style="font-size:1.1rem;font-weight:700;color:<?= $minZ >= 1.8 ? 'var(--danger)' : ($minZ >= 1.5 ? 'var(--warning)' : 'var(--green)') ?>"><?= number_format($minZ,4) ?></td>
                    <td>
                        <?php if ($myZ <= 0): ?>
                            <span style="color:var(--text-muted);font-size:0.8rem">Set Z-score target</span>
                        <?php elseif ($canGet): ?>
                            <span class="badge badge-A">✅ Achievable</span>
                        <?php elseif ($close): ?>
                            <span class="badge badge-C">⚠️ Close</span>
                        <?php else: ?>
                            <span class="badge badge-F">❌ Need more</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <p style="font-size:0.78rem;color:var(--text-muted);margin-top:1rem">* Data shown is sample data. Always verify with official UGC announcements.</p>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
